import numpy as np

def compute_centroid(X, layer):
    return np.mean(X[:, layer, :], axis=0)


def compute_mean_difference(HF_x, HL_x, layer):

    # Compute means
    mu = np.mean(HF_x[:, layer, :], axis=0)
    v = np.mean(HL_x[:, layer, :], axis=0)

    # Compute difference
    difference = v - mu
    MIDP = (mu + v) / 2


    return difference, MIDP, mu, v

